package com.envisioniot.enos.connect_service.v2_1.device;

import com.envisioniot.enos.connect_service.vo.DeviceCreateVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BatchCreateDeviceRequest extends AbstractDeviceRequest {
    private String orgId;

    private String productKey;
    private List<DeviceCreateVo> deviceList;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(7);
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        if (deviceList != null) {
            map.put("deviceList", deviceList);
        }
        return map;
    }

    @Override
    protected String action() {
        return "batchCreate";
    }
}
