package com.envisioniot.enos.connect_service.v2_1.device;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2020/11/2 16:10
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetDeviceStatsRequest extends AbstractDeviceRequest {

    private String orgId;
    private String productKey;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(3);
        map.put("action", action());
        map.put("orgId", orgId);
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    protected String action() {
        return "getStats";
    }

}
