package com.envisioniot.enos.connect_service.v2_1.device;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import com.envisioniot.enos.connect_service.vo.DeviceSearchExtraVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:41
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchDeviceRequest extends AbstractDeviceRequest {

    private String orgId;
    private String expression;
    private Pagination pagination;
    private Projection projection;
    private Boolean populateLastUpdateInfo;
    private DeviceSearchExtraVo extraVo;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (expression != null) {
            map.put("expression", expression);
        }
        if (projection != null) {
            map.put("projection", projection);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        if (populateLastUpdateInfo != null) {
            map.put("populateLastUpdateInfo", populateLastUpdateInfo);
        }
        if (extraVo != null) {
            map.put("extraVo", extraVo);
        }
        return map;
    }

    @Override
    protected String action() {
        return "search";
    }
}
