package com.envisioniot.enos.connect_service.v2_1.device;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:41
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateDeviceRequest extends AbstractSingleDeviceRequest {

    private StringI18n deviceName;
    private String deviceDesc;
    private String timezone;
    private Map<String, Object> deviceAttributes;
    private Map<String, String> deviceTags;
    private Boolean isPatchUpdate;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> params = super.queryParams();
        if (isPatchUpdate != null) {
            params.put("isPatchUpdate", isPatchUpdate);
        }
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(5);
        if (deviceName != null) {
            map.put("deviceName", deviceName);
        }
        if (deviceDesc != null) {
            map.put("deviceDesc", deviceDesc);
        }
        if (timezone != null) {
            map.put("timezone", timezone);
        }
        if (deviceAttributes != null) {
            map.put("deviceAttributes", deviceAttributes);
        }
        if (deviceTags != null) {
            map.put("deviceTags", deviceTags);
        }
        return map;
    }

    @Override
    protected String action() {
        return "update";
    }
}
