package com.envisioniot.enos.connect_service.v2_1.device.log;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2020/10/10 14:58
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractSearchLogRequest extends PoseidonRequest {

    private String orgId;
    private String expression;
    private Pagination pagination;
    private Projection projection;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (expression != null) {
            map.put("expression", expression);
        }
        if (projection != null) {
            map.put("projection", projection);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }

    protected String action() {
        return "search";
    }

    @Override
    public String method() {
        return "POST";
    }

}
