package com.envisioniot.enos.connect_service.v2_1.device.topo;

import com.envisioniot.enos.connect_service.vo.DeviceIdentifier;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:39
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetGatewayRequest extends AbstractDeviceTopoRequest {

    private String orgId;
    private DeviceIdentifier subDevice;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(3);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(2);

        if (subDevice != null) {
            map.put("subDevice", subDevice);
        }
        return map;
    }

    @Override
    protected String action() {
        return "getGateway";
    }
}
