package com.envisioniot.enos.connect_service.v2_1.event;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetEventRequest extends PoseidonRequest {
    private String orgId;
    private String eventId;
    private Boolean resolveName;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "get");
        params.put("orgId", orgId);
        params.put("eventId",eventId);
        params.put("resolveName", resolveName);
        return params;
    }

    @Override
    public String baseUri() {
        return "/connect-service/v2.1/events";
    }

    @Override
    public String method() {
        return  "GET";
    }
}
