package com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack;


import com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack.vo.EquipInfo;
import com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack.vo.PointInfo;
import com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack.vo.SiteInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/2/19 14:58
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateDeviceRequest extends AbstractHaystackRequest {

    private String orgId;

    private List<EquipInfo> equips;
    private List<PointInfo> points;
    private List<SiteInfo> sites;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(2);
        if (equips != null) {
            map.put("equips", equips);
        }
        if (points != null) {
            map.put("points", points);
        }
        if (sites != null) {
            map.put("sites", sites);
        }
        return map;
    }

    @Override
    protected String action() {
        return "createDevices";
    }
}
