package com.envisioniot.enos.connect_service.v2_1.ota.firmware;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-01
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract public class AbstractSingleFirmwareRequest extends AbstractFirmwareRequest {

    protected String orgId;
    protected String firmwareId;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (firmwareId != null) {
            map.put("firmwareId", firmwareId);
        }
        return map;
    }

}
