package com.envisioniot.enos.connect_service.v2_1.ota.firmware;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import com.envisioniot.enos.connect_service.vo.ota.SignMethod;
import com.google.common.hash.Hashing;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.SneakyThrows;
import lombok.ToString;
import org.apache.commons.codec.digest.DigestUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-02
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateFirmwareFileRequest extends AbstractFirmwareRequest {

    private String orgId;
    private String productKey;

    private StringI18n name;
    private String version;
    private String signMethod;
    private String desc;
    private Boolean enableVerification;

    private File file;

    private Map<String, String> firmwareTags;
    private Integer maxAllowedForVerification;
    private Integer minSuccessForVerified;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(3);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @SneakyThrows
    @Override
    public Map<String, Object> formData() {
        Map<String, Object> map = new HashMap<>(2);
        if (file != null) {
            map.put("file", file);
        }
        map.put("metadata", buildJsonPayload());
        return map;
    }

    private Map<String, Object> buildJsonPayload() throws IOException {
        Map<String, Object> payload = new HashMap<>(5);
        if (name != null) {
            payload.put("name", name);
        }
        if (version != null) {
            payload.put("version", version);
        }
        if (signMethod != null) {
            payload.put("signMethod", signMethod);
        }
        if (file != null) {
            if (SignMethod.MD5.equalsIgnoreCase(signMethod)) {
                payload.put("sign", DigestUtils.md5Hex(new FileInputStream(file)));
            } else if (SignMethod.SHA256.equalsIgnoreCase(signMethod)) {
                payload.put("sign", DigestUtils.sha256Hex(new FileInputStream(file)));
            }
        }
        if (desc != null) {
            payload.put("desc", desc);
        }
        if (enableVerification != null) {
            payload.put("enableVerification", enableVerification);
        }
        if (firmwareTags != null) {
            payload.put("firmwareTags", firmwareTags);
        }
        if(maxAllowedForVerification != null){
            payload.put("maxAllowedForVerification", maxAllowedForVerification);
        }
        if(minSuccessForVerified != null){
            payload.put("minSuccessForVerified", minSuccessForVerified);
        }
        return payload;
    }


    @Override
    protected String action() {
        return "create";
    }
}
