package com.envisioniot.enos.connect_service.v2_1.ota.firmware;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-04
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ListDeviceCurrentFirmwaresRequest extends AbstractFirmwareRequest {
    private String orgId;
    private String productKey;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    protected String action() {
        return "listVersion";
    }
}
