package com.envisioniot.enos.connect_service.v2_1.ota.job;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-09
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractSingleJobRequest extends AbstractJobRequest {
    protected String orgId;
    protected String jobId;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(3);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (jobId != null) {
            map.put("jobId", jobId);
        }
        return map;
    }
}
