package com.envisioniot.enos.connect_service.v2_1.product;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhonghua.wu
 * @date 2019-07-18
 */

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateProductRequest extends AbstractProductRequest {

    private String orgId;
    private StringI18n productName;
    private String productDesc;
    private String dataFormat;
    private String productType;
    private String modelId;
    private Boolean biDirectionalAuth;
    private Boolean dynamicActivateEnabled;
    private Map<String, String> productTags;

    private Integer maxValidDay;
    private Integer defaultValidDay;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        if (productName != null) {
            map.put("productName", productName);
        }
        if (productDesc != null) {
            map.put("productDesc", productDesc);
        }
        if (modelId != null) {
            map.put("modelId", modelId);
        }
        if (dataFormat != null) {
            map.put("dataFormat", dataFormat);
        }
        if (productType != null) {
            map.put("productType", productType);
        }
        if (biDirectionalAuth != null) {
            map.put("biDirectionalAuth", biDirectionalAuth);
        }
        if (dynamicActivateEnabled != null) {
            map.put("dynamicActivateEnabled", dynamicActivateEnabled);
        }
        if (productTags != null) {
            map.put("productTags", productTags);
        }
        if(maxValidDay != null){
            map.put("maxValidDay",maxValidDay);
        }
        if(defaultValidDay != null){
            map.put("defaultValidDay",defaultValidDay);
        }
        return map;

    }

    @Override
    public String action() {
        return "create";
    }
}
