package com.envisioniot.enos.connect_service.v2_1.product;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteProductRequest extends AbstractProductRequest {

    String orgId;
    String productKey;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @Override
    String action() {
        return "delete";
    }
}
