package com.envisioniot.enos.connect_service.v2_1.product;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchProductRequest extends AbstractProductRequest {

    private String orgId;
    private String expression;
    private Pagination pagination;
    private Projection projection;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> params = new HashMap<>(2);
        params.put("action", action());
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> params = new HashMap<>(3);
        if (expression != null) {
            params.put("expression", expression);
        }
        if (pagination != null) {
            params.put("pagination", pagination);
        }
        if (projection != null) {
            params.put("projection", projection);
        }
        return params;
    }

    @Override
    String action() {
        return "search";
    }
}
