package com.envisioniot.enos.connect_service.v2_2.device.private_req;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/8/6 17:16
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PrivateCreateDeviceRequest extends AbstractPrivateDeviceRequest {
    private String orgId;

    private String assetId;

    private String productKey;
    private String timezone;
    private Map<String, Object> deviceAttributes;
    private Map<String, String> deviceTags;

    private String deviceKey;
    private String deviceSecret;
    private StringI18n deviceName;
    private String deviceDesc;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(9);
        if (assetId != null) {
            map.put("assetId", assetId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        if (timezone != null) {
            map.put("timezone", timezone);
        }
        if (deviceAttributes != null) {
            map.put("deviceAttributes", deviceAttributes);
        }
        if (deviceTags != null) {
            map.put("deviceTags", deviceTags);
        }
        if (deviceKey != null) {
            map.put("deviceKey", deviceKey);
        }
        if (deviceSecret != null) {
            map.put("deviceSecret", deviceSecret);
        }
        if (deviceName != null) {
            map.put("deviceName", deviceName);
        }
        if (deviceDesc != null) {
            map.put("deviceDesc", deviceDesc);
        }
        return map;
    }

    @Override
    protected String action() {
        return "create";
    }
}
