package com.envisioniot.enos.connect_service.vo;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class Device implements Serializable {
    private static final long serialVersionUID = 8289431333428601675L;

    private String orgId;
    private String assetId;
    private String modelId;
    private String modelIdPath;
    private String productKey;
    private StringI18n productName;
    private String productType;
    private String dataFormat;
    private String deviceKey;
    private StringI18n deviceName;
    private String deviceSecret;
    private String deviceDesc;
    private String timezone;
    private Map<String, Object> deviceAttributes;
    private Map<String, String> deviceTags;
    private String mirrorSource;
    private String firmwareVersion;
    private Long createTime;
    private String status;
    private Long activeTime;
    private Long lastOnlineTime;
    private Long lastOfflineTime;

    private Long measurepointLastUpdate;
    private Long eventLastUpdate;
    private Long attributeLastUpdate;

    /**
     * This is the max value among measurepointLastUpdate, eventLastUpdate and attributeUpdate.
     * Currently, not find a better descriptive name for it.
     */
    private Long featureLastUpdate;
}

