package com.envisioniot.enos.connect_service.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Optional;

/**
 * @Author: song.xu
 * @Date: 2021/12/23
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DeviceSearchExtraVo implements Serializable {

    private static final long serialVersionUID = -2740361056794163543L;
    private Boolean realTime;

    /**
     * realTime = true | null，保证返回结果的正确性
     * realTime = false，保证查询速度
     */
    public boolean adjustRealTime() {
        return Optional.ofNullable(realTime).orElse(true);
    }

    public static boolean getOrDefaultRealTime(DeviceSearchExtraVo extraVo) {
        return Optional.ofNullable(extraVo).map(DeviceSearchExtraVo::adjustRealTime).orElse(true);
    }
}
