package com.envisioniot.enos.connect_service.vo.ota;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author :charlescai
 * @date :2020-06-03
 */
@Data
public class UpgradeScope implements Serializable {
    private static final long serialVersionUID = -8074952271188037259L;
    /**
     * 升级范围类型，total : 全部设备(满足versionFilter字段的设备)，partial: 定向设备(满足所有filter字段的交集设备)
     */
    private String type;

    /**
     * 待升级版本号 (必填)
     */
    private Set<String> versionNumbers;

    /**
     * 按deviceKey筛选
     */
    private Set<String> deviceKeys;

    /**
     * 按attribute筛选，key为attribute key，value为attribute value，如： brand => apple
     */
    private Map<String, List<Object>> attributes;

    /**
     * 按tag筛选，key为tag key，value为tag value，如： province => shanghai
     */
    private Map<String, List<String>> tags;

    /**
     * 按资产树筛选，支持正选和反选节点，最多选择五棵资产树
     */
    private Set<AssetTreeScope> assetTrees;

    @Data
    public static class AssetTreeScope {
        private String treeId;

        private Set<String> includedNodes;
    }
}
