package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AggregateActiveAlertRequest extends PoseidonRequest {
    private String orgId;
    private String groupByField;
    private String startOccurTime;
    private String endOccurTime;
    private String expression;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "aggregate");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "aggregate");

        if(groupByField != null){
            params.put("groupByField",groupByField);
        }

        if(startOccurTime != null){
            params.put("startOccurTime",startOccurTime);
        }
        if(endOccurTime != null){
            params.put("endOccurTime",endOccurTime);
        }
        if(expression != null){
            params.put("expression",expression);
        }

        return params;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
