package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.event_service.vo.GenerateActiveAlert;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CloseActiveAlertRequest extends PoseidonRequest {


    private String orgId;
    private String eventId;
    private Long recoverTime;
    private String localRecoverTime;
    private String recoverReason;


    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "close");
        map.put("orgId", orgId);
        map.put("eventId",eventId);
        map.put("recoverTime",recoverTime);
        map.put("localRecoverTime",localRecoverTime);
        map.put("recoverReason",recoverReason);
        return map;
    }

    public Class<CloseActiveAlertResponse> getResponseClass() {
        return CloseActiveAlertResponse.class;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
