package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.event_service.vo.GenerateActiveAlert;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateActiveAlertRequest extends PoseidonRequest {


    private String orgId;
    private GenerateActiveAlert activeAlert;


    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        if (activeAlert != null) {
            map.put("activeAlert", activeAlert);
        }
        return map;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
