package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.event_service.vo.AssetNode;
import com.envisioniot.enos.event_service.vo.DeviceStatus;
import com.envisioniot.enos.event_service.vo.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author by tao.wu
 * @date 2019/7/8 11:53
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateAlertRuleRequest extends AbstractAlertRuleRequest {
    private String orgId;
    private String ruleId;
    private String measurepointId;
    private String deviceStatus;
    private String modelId;
    private StringI18n ruleDesc;
    private String condition;
    private String severityId;
    private String contentId;
    private Map<String,String> tags = new HashMap<>();
    private Boolean isEnabled ;
    private Boolean isRoot ;
    private List<AssetNode> scope;
    private String  source;
    private Integer triggeringDelayTimer;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> map = new HashMap<>();
        map.put("ruleId",ruleId);
        map.put("ruleDesc",ruleDesc);
        map.put("modelId",modelId);
        map.put("measurepointId",measurepointId);
        map.put("deviceStatus",deviceStatus);
        map.put("condition",condition);
        map.put("severityId",severityId);
        map.put("contentId", contentId);
        map.put("tags",tags);
        map.put("isEnabled",isEnabled);
        map.put("isRoot",isRoot);
        map.put("scope",scope);
        map.put("source",source);
        map.put("triggeringDelayTimer",triggeringDelayTimer);
        return map;
    }
}
