package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.event_service.vo.GenerateType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateAlertTypeRequest extends AbstractAlertTypeRequest{

    private String orgId;
    private GenerateType type;


    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        if (type != null) {
            map.put("type", type);
        }
        return map;
    }
}
