package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteActiveAlertRequest extends PoseidonRequest {


    private String orgId;
    private String eventId;


    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "delete");
        map.put("orgId", orgId);
        map.put("eventId", eventId);
        return map;
    }


    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
