package com.envisioniot.enos.event_service.v2_1;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author by tao.wu
 * @date 2019/7/8 18:47
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteAlertRuleRequest extends AbstractAlertRuleRequest {
    private String orgId;
    private String ruleId;
    private String source;

    @Override
    public String baseUri() {
        return super.baseUri();
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(3);
        map.put("action", "delete");
        map.put("orgId", orgId);
        map.put("ruleId", ruleId);
        map.put("source", source);

        return map;
    }

}
