package com.envisioniot.enos.event_service.v2_1;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteAlertSeverityRequest  extends AbstractAlertSeverityRequest  {
    private String orgId;
    private String severityId;
    private String source;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "delete");
        map.put("orgId", orgId);
        map.put("severityId", severityId);
        map.put("source", source);
        return map;
    }

}
