package com.envisioniot.enos.event_service.v2_1;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/5/24 19:47
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetAlertContentRequest extends AbstractAlertContentRequest {

    private String orgId;
    private String contentId;

    @Override
    public String baseUri() {
        return super.baseUri();
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(3);
        map.put("action", "get");
        map.put("orgId", orgId);
        map.put("contentId", contentId);
        return map;
    }

}
