package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Scroll;
import com.envisioniot.enos.event_service.vo.RootAlert;
import com.envisioniot.enos.event_service.vo.Scope;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScrollHistoryAlertRequest extends PoseidonRequest {
    private String orgId;
    private String modelId;
    private String assetId;
    private String measurepointId;
    private String startOccurTime;
    private String endOccurTime;
    private String recoverStartTime;
    private String recoverEndTime;
    private String expression;
    private Scroll scroll;
    private Scope scope;
    private RootAlert rootAlert;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "scroll");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(modelId != null){
            params.put("modelId",modelId);
        }
        if(assetId != null){
            params.put("assetId",assetId);
        }
        if(measurepointId != null){
            params.put("measurepointId",measurepointId);
        }
        if(startOccurTime != null){
            params.put("startOccurTime",startOccurTime);
        }
        if(endOccurTime != null){
            params.put("endOccurTime",endOccurTime);
        }
        if(recoverStartTime != null){
            params.put("recoverStartTime",recoverStartTime);
        }
        if(recoverEndTime != null){
            params.put("recoverEndTime",recoverEndTime);
        }
        if(expression != null){
            params.put("expression",expression);
        }
        if (scroll != null) {
            params.put("scroll", scroll);
        }
        if (scope != null)
        {
            params.put("scope", scope);
        }
        if (rootAlert != null)
        {
            params.put("rootAlert", rootAlert);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/history-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
