package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/5/24 19:57
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchAlertContentRequest extends AbstractAlertContentRequest {

    private String orgId;
    private String modelId;
    private String alertTypeId;
    private String subAlertTypeId;
    private String expression;
    private Pagination pagination;

    @Override
    public String baseUri() {
        return super.baseUri() ;
    }

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        if (modelId != null) {
            map.put("modelId", modelId);
        }
        if (alertTypeId != null) {
            map.put("alertTypeId", alertTypeId);
        }
        if (subAlertTypeId != null) {
            map.put("subAlertTypeId", subAlertTypeId);
        }
        if (expression != null) {
            map.put("expression", expression);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }

}
