package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateActiveAlertTagsRequest extends PoseidonRequest {
    private String orgId;
    private String eventId;
    private Map<String, String> tags;
    private Boolean isPatchUpdate;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "updateTags");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();


        if(eventId != null){
            params.put("eventId",eventId);
        }
        if(tags != null){
            params.put("tags",tags);
        }
        if(isPatchUpdate != null){
            params.put("isPatchUpdate",isPatchUpdate);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
