package com.envisioniot.enos.event_service.vo;

/**
 *
 */
public enum DeviceStatus {

    /**
     * 离线
     */
    DEVICE_OFFLINE("offline");

    private String statusName;

    DeviceStatus(String statusName) {
        this.statusName = statusName;
    }

    public String getStatusName() {
        return statusName;
    }

    /**
     * 构造一个设备状态的枚举值，如果参数错误，返回空
     * @param statusName
     * @return 根据字符串返回枚举值。如果没找到指定枚举值，返回null
     *
     */
    public static DeviceStatus buildDeviceStatusValue(String statusName){
        if(DEVICE_OFFLINE.getStatusName().equalsIgnoreCase(statusName)){
            return DeviceStatus.DEVICE_OFFLINE;
        }else{
            return null;
        }
    }



    public static void main(String args[]){
        DeviceStatus value = null;
        DeviceStatus value1 = DeviceStatus.buildDeviceStatusValue("offline");
        System.out.println(value);
    }
}
