package com.envisioniot.enos.event_service.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class GenerateContent implements Serializable {
    /**
     * 告警内容编号，orgId下唯一
     */
    private String contentId;
    /**
     * 告警内容描述，其中default必填
     */
    private StringI18n contentDesc;
    /**
     * 模型id，该告警内容适用的模型
     */
    private String modelId;
    /**

     * 引用的告警类型编号
     */
    private String alertTypeId;
    /**
     * 引用额告警子类型编号
     */
    private String subAlertTypeId;
    /**
     * 编号
     */
    private Map<String,String> tags;

    /**
     * 如果为null，代表云端的。否则，代表盒子端的。
     */
    private String source;
}
