package com.envisioniot.enos.event_service.vo;

import java.io.Serializable;

/**
 * @author : gaozhijun
 * @date : 2019/7/24 0:59
 */
public class Scope implements Serializable {

    private static final long serialVersionUID = -2062478521927035327L;
    /**
     * 资产树ID required
     */
    private String treeId;

    /**
     * 是否返回被屏蔽的告警，默认为false，不返回被屏蔽的告警。</br>
     * not required
     */
    private boolean includeDerivative;

    /**
     * 资产ID，用来指定资产树上的一个资产节点，返回这个资产节点下的所有告警，包括这个资产节点本身的告警。 </br>
     * not required
     */
    private String fromAssetId;

    public Scope() {}

    public Scope(String treeId) {
        this.treeId = treeId;
    }

    public Scope(String treeId, boolean includeDerivative) {
        this.treeId = treeId;
        this.includeDerivative = includeDerivative;
    }

    public Scope(String treeId, boolean includeDerivative, String fromAssetId) {
        this.treeId = treeId;
        this.includeDerivative = includeDerivative;
        this.fromAssetId = fromAssetId;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public boolean isIncludeDerivative() {
        return includeDerivative;
    }

    public void setIncludeDerivative(boolean includeDerivative) {
        this.includeDerivative = includeDerivative;
    }

    public String getFromAssetId() {
        return fromAssetId;
    }

    public void setFromAssetId(String fromAssetId) {
        this.fromAssetId = fromAssetId;
    }
}
