package com.envisioniot.enos.event_service.vo.condition;

import java.util.ArrayList;
import java.util.List;

/**
 * complex condition composed by logical AND
 * @author hongjie.shan
 * @date 2018/12/14
 */
public class AndCondition extends AbstractCondition {

    private static final long serialVersionUID = -7796684929414411387L;

    private final ConditionType conditionType = ConditionType.LOGIC_AND;

    private List<AbstractCondition> conditionList = new ArrayList<>();

    public AndCondition() {
    }

    /**
     * create logical all condition
     * @param conditionList
     */
    public AndCondition(List<AbstractCondition> conditionList) {
        this.conditionList = conditionList;
    }

    public List<AbstractCondition> getConditionList() {
        return conditionList;
    }

    public void setConditionList(List<AbstractCondition> conditionList) {
        this.conditionList = conditionList;
    }

    @Override
    public ConditionType getConditionType() {
        return conditionType;
    }
}
