package com.envisioniot.enos.event_service.vo.condition;


import com.envisioniot.enos.event_service.vo.condition.operator.SimpleOperator;

/**
 * relative condition without complex logic
 * for datapoint of struct type, simple condition can between two items, eg: name > anotherName
 * @author hongjie.shan
 * @date 2018/12/14
 */
public class RelativeCondition extends AbstractCondition {

    private static final long serialVersionUID = 7323204636373943214L;

    private final ConditionType conditionType = ConditionType.RELATIVE;

    /**
     * item full path
     * eg: structtest/item1 (structtest: point id, item1: item id)
     */
    private String name;

    private SimpleOperator operator;

    /**
     * another item name of the relative condition for struct
     */
    private String anotherName;

    public RelativeCondition() {
    }

    /**
     * only use for struct, compare one item in the struct to another item
     * @param oneItemName
     * @param anotherItemName
     * @param operator
     */
    public RelativeCondition(String oneItemName, SimpleOperator operator, String anotherItemName) {
        this.name = oneItemName;
        this.operator = operator;
        this.anotherName = anotherItemName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SimpleOperator getOperator() {
        return operator;
    }

    public void setOperator(SimpleOperator operator) {
        this.operator = operator;
    }


    public String getAnotherName() {
        return anotherName;
    }

    /**
     * set another item name of the same struct
     * anotherName has higher priority over value, if anotherName is set, the comparing is relative comparing
     * between two items in the same struct
     * @param anotherName
     */
    public void setAnotherName(String anotherName) {
        this.anotherName = anotherName;
    }

    @Override
    public ConditionType getConditionType() {
        return conditionType;
    }


}
