package com.envisioniot.enos.logic_asset_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DeleteLogicAssetRequest extends PoseidonRequest {
    private String orgId;
    private String assetId;


    @Override
    public String baseUri()
    {
        return "/asset-service/v2.1/logical-assets";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "delete");
        params.put("orgId", orgId);
        params.put("assetId", assetId);
        return params;

    }
}
