package com.envisioniot.enos.model_service.v2_1;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import com.envisioniot.enos.model_service.vo.ThingAttribute;
import com.envisioniot.enos.model_service.vo.ThingEvent;
import com.envisioniot.enos.model_service.vo.ThingMeasurepoint;
import com.envisioniot.enos.model_service.vo.ThingService;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName AbstractThingModelRequest
 * @Description TODO
 * @date 2020/5/19 12:44
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractThingModelRequest extends AbstractModelRequest {
    private String orgId;
    /**
     * thing model
     */
    private String modelId;
    private StringI18n name;
    private String category;
    private Boolean enableMeasurepointValidate;
    private String desc;
    private Map<String, String> tags;
    private Map<String, ThingAttribute> attributes;
    private Map<String, ThingMeasurepoint> measurepoints;
    private Map<String, ThingEvent> events;
    private Map<String, ThingService> services;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("modelId", modelId);
        if (name != null) {
            map.put("name", name);
        }
        map.put("desc", desc);
        map.put("category",category);
        if (tags != null) {
            map.put("tags", tags);
        }
        if (attributes != null) {
            map.put("attributes", attributes);
        }
        if (measurepoints != null) {
            map.put("measurepoints", measurepoints);
        }
        if (events != null) {
            map.put("events", events);
        }
        if (services != null) {
            map.put("services", services);
        }
        return map;
    }
}
