package com.envisioniot.enos.model_service.v2_1;

import lombok.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName DeleteThingModel
 * @Description TODO
 * @date 2020/5/19 12:49
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class DeleteThingModelRequest extends AbstractModelRequest {

    private String orgId;
    private String modelId;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("orgId", orgId);
        map.put("action", action());
        map.put("modelId", modelId);
        return map;
    }

    /**
     * return action name
     *
     * @return action name
     */
    @Override
    protected String action() {
        return "delete";
    }

    /**
     * request 's response class
     *
     * @return
     */
    @Override
    public Class<DeleteThingModelResponse> getResponseClass() {
        return DeleteThingModelResponse.class;
    }
}
