package com.envisioniot.enos.model_service.vo;

import lombok.Data;

/**
 * @author hongjie.shan
 * @date 2019/5/22
 */
@Data
public class ThingDatapoint extends ThingElement {
    private String dataType;

    private Unit unit;

    private String dataDefinition;

    private Boolean isRequired;
    private Object defaultValue;

    /* supports limits of integer, float, double, string, date and array,
       so using string as type is much more suitable */
    private String lowerLimit;
    private String upperLimit;

    public static void setLowerLimit(ThingDatapoint thingDatapoint, Number lowerLimit) {
        if (thingDatapoint != null && lowerLimit != null) {
            thingDatapoint.setLowerLimit(String.valueOf(lowerLimit));
        }
    }

    public static void setUpperLimit(ThingDatapoint thingDatapoint, Number upperLimit) {
        if (thingDatapoint != null && upperLimit != null) {
            thingDatapoint.setUpperLimit(String.valueOf(upperLimit));
        }
    }
}
