/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common;

import com.envision.energy.connective.common.IProtoProcessor;
import com.envision.energy.connective.common.RegManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoHandler
extends ChannelInboundHandlerAdapter {
    private static Logger logger = LoggerFactory.getLogger((String)"ProtoHandler");
    private static AttributeKey<String> CH_USER_KEY = AttributeKey.valueOf((String)"CH_USER_KEY");

    protected String getUserKey(ChannelHandlerContext ctx) {
        String userKey = null;
        Attribute userKeyAttr = ctx.channel().attr(CH_USER_KEY);
        if (userKeyAttr != null && userKeyAttr.get() != null) {
            userKey = (String)userKeyAttr.get();
        }
        return userKey;
    }

    protected String getErrId(ChannelHandlerContext ctx) {
        return this.getUserKey(ctx) + "_" + ctx.channel().remoteAddress();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("exceptionCaught: " + this.getErrId(ctx) + " >>> ", cause);
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        IProtoProcessor<Object> handler;
        if (logger.isDebugEnabled()) {
            logger.debug("proto handler: " + ctx.channel().remoteAddress() + ">>" + msg);
        }
        if ((handler = RegManager.getProcessor(msg.getClass())) != null) {
            handler.receive(ctx, msg);
        }
        ctx.fireChannelRead(msg);
    }
}

