/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common;

import com.envision.energy.connective.common.IProtoProcessor;
import com.google.protobuf.Parser;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegManager {
    private static Logger logger = LoggerFactory.getLogger(RegManager.class);
    private static Map<Integer, Parser<?>> decoderMap = new ConcurrentHashMap();
    private static Map<Class<?>, Integer> encoderMap = new ConcurrentHashMap();
    private static Map<Class<?>, IProtoProcessor<?>> processorMap = new ConcurrentHashMap();

    public static <T> void register(Integer cmdId, Class<T> cls) {
        RegManager.register(cmdId, cls, null);
    }

    public static <T> void register(Integer cmdId, Class<T> cls, IProtoProcessor<T> processor) {
        if (processor != null) {
            processorMap.put(cls, processor);
        }
        try {
            Field parser_field = cls.getField("PARSER");
            Parser parser = (Parser)parser_field.get(cls);
            decoderMap.put(cmdId, parser);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        encoderMap.put(cls, cmdId);
    }

    public static <T> Parser<T> getDecoderParser(Integer cmdId) {
        return decoderMap.get(cmdId);
    }

    public static <T> Integer getEncoderCmd(Class<T> cls) {
        return encoderMap.get(cls);
    }

    public static <T> IProtoProcessor<T> getProcessor(Class<?> cls) {
        return processorMap.get(cls);
    }
}

