/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.channel;

import com.envision.energy.connective.common.ProtoHandler;
import com.envision.energy.connective.common.channel.IChannelHandlerGenerator;
import com.envision.energy.connective.common.channel.impl.SimpleHandlerGenerator;
import com.envision.energy.connective.common.protobuf.Decoder;
import com.envision.energy.connective.common.protobuf.Encoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static Logger logger = LoggerFactory.getLogger(DefaultChannelInitializer.class);
    protected Map<AddChannelHandlerPoint, List<? extends IChannelHandlerGenerator>> generatorMap = new HashMap<AddChannelHandlerPoint, List<? extends IChannelHandlerGenerator>>();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
        logger.error("default channel catch exception", cause);
    }

    public DefaultChannelInitializer() {
        this.initStandardHandler();
    }

    public DefaultChannelInitializer(Map<AddChannelHandlerPoint, List<IChannelHandlerGenerator>> generatorMap) {
        this.initStandardHandler();
        this.generatorMap.putAll(generatorMap);
    }

    protected void initStandardHandler() {
        this.generatorMap.put(AddChannelHandlerPoint.EncoderPoint, Collections.singletonList(new SimpleHandlerGenerator(Encoder.class)));
        this.generatorMap.put(AddChannelHandlerPoint.DecoderPoint, Collections.singletonList(new SimpleHandlerGenerator(Decoder.class)));
        this.generatorMap.put(AddChannelHandlerPoint.ProtoHandlerPoint, Collections.singletonList(new SimpleHandlerGenerator(ProtoHandler.class)));
    }

    private void addHandlerToChannel(ChannelPipeline pipeline, AddChannelHandlerPoint point) {
        List<? extends IChannelHandlerGenerator> generatorList = this.generatorMap.get((Object)point);
        if (generatorList != null && !generatorList.isEmpty()) {
            for (IChannelHandlerGenerator iChannelHandlerGenerator : generatorList) {
                pipeline.addLast(new ChannelHandler[]{iChannelHandlerGenerator.generate()});
                if (!logger.isDebugEnabled()) continue;
                logger.debug("pipeline add channel handler at:" + iChannelHandlerGenerator + pipeline.last().getClass());
            }
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        for (AddChannelHandlerPoint point : AddChannelHandlerPoint.values()) {
            this.addHandlerToChannel(pipeline, point);
        }
    }

    public static enum AddChannelHandlerPoint {
        EncoderBeforePoint,
        EncoderPoint,
        EncoderAfterPoint,
        DecoderBeforePoint,
        DecoderPoint,
        DecoderAfterPoint,
        ProtoHandlerBeforePoint,
        ProtoHandlerPoint,
        ProtoHandlerAfterPoint;

    }
}

