/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.protobuf;

import com.envision.energy.connective.common.RegManager;
import com.envision.energy.connective.common.protobuf.generated.Common;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Parser;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyse {
    private static Logger logger = LoggerFactory.getLogger(Analyse.class);
    private static final int MAX_LENGTH = 0x7D0000;
    public static final int ACK_CMD = -1;

    public static Common.TransferPkg parse(ByteBuf in) throws Exception {
        in.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                if (logger.isDebugEnabled()) {
                    logger.debug("bytebuf not readable.");
                }
                return null;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (length > 0x7D0000) {
                throw new CorruptedFrameException("length greater than max length: " + length);
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return null;
            }
            return Analyse.getPkg(in, length);
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }

    public static void parseData(List<Object> out, Common.TransferPkg pkg) throws Exception {
        Parser parser = RegManager.getDecoderParser(pkg.getCmdId());
        if (parser == null) {
            logger.warn("cmd: " + pkg.getCmdId() + " not found parser!");
        } else if (pkg.hasVer() && pkg.getVer() >= 1 && pkg.hasZip() && pkg.getZip()) {
            out.add(parser.parseFrom(Analyse.getUncompressData(pkg.getData())));
        } else {
            out.add(parser.parseFrom(pkg.getData()));
        }
    }

    private static byte[] getUncompressData(ByteString bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes.toByteArray());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPInputStream input = new GZIPInputStream(bais);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = input.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            input.close();
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            return new byte[0];
        }
    }

    private static Common.TransferPkg getPkg(ByteBuf in, int length) throws Exception {
        ByteBuf buffer = in.readBytes(length);
        byte[] array = buffer.array();
        int offset = buffer.arrayOffset() + buffer.readerIndex();
        try {
            return (Common.TransferPkg)Common.TransferPkg.getDefaultInstance().getParserForType().parseFrom(array, offset, length);
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String d = "int length = CodedInputStream.newInstance(buf, 0, i + 1).readRawVarint32();ByteArrayInputStream bais = new ByteArrayInputStream(bytes.toByteArray());GZIPOutputStream output = new GZIPOutputStream(baos);byte[] unzipData = getUncompressData(ByteString.copyFrom(gzipData));int length = CodedInputStream.newInstance(buf, 0, 2).readRawVarint32();return TransferPkg.getDefaultInstance().getParserForType().parseFrom(array, offset, length);";
            byte[] data = d.getBytes("utf-8");
            GZIPOutputStream output = new GZIPOutputStream(baos);
            output.write(data);
            output.finish();
            output.close();
            byte[] gzipData = baos.toByteArray();
            System.out.println("data: " + data.length + "; zip: " + gzipData.length);
            byte[] unzipData = Analyse.getUncompressData(ByteString.copyFrom((byte[])gzipData));
            System.out.println("unzip: " + unzipData.length + "; data: " + new String(unzipData, "utf-8"));
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
    }
}

