/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.protobuf;

import com.envision.energy.connective.common.protobuf.Analyse;
import com.envision.energy.connective.common.protobuf.FlowStatistics;
import com.envision.energy.connective.common.protobuf.NetworkTraffic;
import com.envision.energy.connective.common.protobuf.TransferVer;
import com.envision.energy.connective.common.protobuf.generated.Common;
import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decoder
extends ByteToMessageDecoder {
    private static Logger logger = LoggerFactory.getLogger((String)"Decoder");
    private static final AttributeKey<Integer> CH_HB_ID = AttributeKey.valueOf((String)"CH_HB_ID");
    private static final AttributeKey<Integer> CH_LAST_ACK_ID = AttributeKey.valueOf((String)"CH_LAST_ACK_ID");
    private FlowStatistics inboundFlow = new FlowStatistics("Decode");

    public static int getCurHeartbeat(Channel channel) {
        Integer heartbeat = (Integer)channel.attr(CH_HB_ID).get();
        if (heartbeat == null) {
            logger.info("last hb id attr null: " + channel.remoteAddress());
            return 0;
        }
        return heartbeat;
    }

    public static int getLastAck(Channel channel) {
        Integer lastAck = (Integer)channel.attr(CH_LAST_ACK_ID).get();
        if (lastAck == null) {
            logger.info("last ack id attr null: " + channel.remoteAddress());
            return 0;
        }
        return lastAck;
    }

    public static void setCurHeartbeat(Channel channel, int heartbeat) {
        Attribute hbAttr = channel.attr(CH_HB_ID);
        hbAttr.set((Object)heartbeat);
    }

    public static void setLastAck(Channel channel, int lastAck) {
        Attribute lastAckAttr = channel.attr(CH_LAST_ACK_ID);
        lastAckAttr.set((Object)lastAck);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Common.TransferPkg pkg = Analyse.parse(in);
        if (pkg == null) {
            return;
        }
        this.inboundFlow.updateByteCnt(ctx, pkg.getSerializedSize());
        NetworkTraffic.getByChannel(ctx.channel()).updateDeCnt(pkg.getSerializedSize(), 1);
        TransferVer.setChannelVer(ctx, pkg);
        if (pkg.getCmdId() == -1) {
            logger.info("heartbeat: " + ctx.channel().remoteAddress() + ">>> " + pkg.getSeqId());
            return;
        }
        if (this.checkIfAckNeeded(ctx, pkg)) {
            Analyse.parseData(out, pkg);
        }
    }

    private boolean checkIfAckNeeded(ChannelHandlerContext ctx, Common.TransferPkg pkg) {
        int seqId = pkg.getSeqId();
        if (seqId == 0) {
            logger.debug("get seqId=0: " + pkg.getCmdId() + " >> " + ctx.channel().remoteAddress());
            return true;
        }
        int ackId = Decoder.getCurHeartbeat(ctx.channel());
        if (seqId < 0 && (seqId = -seqId) <= ackId) {
            logger.debug("discard seqid: " + seqId + " : " + pkg.getCmdId() + " cur Ack: " + ackId);
            return false;
        }
        Decoder.setCurHeartbeat(ctx.channel(), seqId);
        if (seqId - Decoder.getLastAck(ctx.channel()) >= 100) {
            Decoder.writeAck(ctx);
        }
        return true;
    }

    public static void writeAck(ChannelHandlerContext ctx) {
        int heartbeat = Decoder.getCurHeartbeat(ctx.channel());
        ctx.writeAndFlush((Object)Common.TransferPkg.newBuilder().setCmdId(-1).setSeqId(heartbeat).setData(ByteString.EMPTY).setZip(false).setVer(TransferVer.getChannelVer(ctx)).build().toByteArray());
        Decoder.setLastAck(ctx.channel(), heartbeat);
        logger.debug(ctx.channel().remoteAddress() + " write hb: " + heartbeat);
    }
}

