/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.protobuf;

import com.envision.energy.connective.common.RegManager;
import com.envision.energy.connective.common.protobuf.FlowStatistics;
import com.envision.energy.connective.common.protobuf.NetworkTraffic;
import com.envision.energy.connective.common.protobuf.TransferVer;
import com.envision.energy.connective.common.protobuf.generated.Common;
import com.envision.eos.commons.pojo.Pair;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encoder
extends MessageToByteEncoder<Object> {
    private static Logger logger = LoggerFactory.getLogger((String)"Encoder");
    private static final int ZIPLEN = 50;
    private FlowStatistics outboundFlow = new FlowStatistics("Encode");

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        String msgName;
        ByteBuf buf;
        Class<?> cls = msg.getClass();
        if (cls == byte[].class) {
            buf = Unpooled.wrappedBuffer((byte[])((byte[])msg));
            msgName = "kvPair/alert";
        } else {
            Integer cmdId = null;
            MessageLite send = null;
            if (cls == Pair.class) {
                Pair pair = (Pair)msg;
                cmdId = (Integer)pair.first;
                if (cmdId == null) {
                    logger.warn("send cmdId is null");
                    return;
                }
                send = (MessageLite)pair.second;
            } else {
                cmdId = RegManager.getEncoderCmd(cls);
                if (cmdId == null) {
                    logger.warn("not found cmd for cls(" + cls + ")");
                    return;
                }
                send = (MessageLite)msg;
            }
            buf = this.getBuf(ctx, cmdId, send);
            msgName = "cmd#" + String.valueOf(cmdId);
        }
        this.outboundFlow.updateByteCnt(ctx, buf.readableBytes());
        NetworkTraffic.getByChannel(ctx.channel()).updateEnCnt(msgName, buf.readableBytes(), 1);
        this.writeBuf(out, buf);
    }

    private ByteBuf getBuf(ChannelHandlerContext ctx, int cmdId, MessageLite send) {
        ByteString data = send == null ? ByteString.EMPTY : send.toByteString();
        int ver = TransferVer.getChannelVer(ctx);
        boolean zip = ver < 1 ? false : Encoder.needZip(data);
        ByteString d = zip ? Encoder.getCompressData(data) : data;
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])Common.TransferPkg.newBuilder().setSeqId(0).setCmdId(cmdId).setData(d).setZip(zip).setVer(ver).build().toByteArray());
        return buf;
    }

    public static boolean needZip(ByteString data) {
        return data.size() > 50;
    }

    public static ByteString getCompressData(ByteString data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream output = new GZIPOutputStream(baos);
            output.write(data.toByteArray());
            output.finish();
            output.close();
            return ByteString.copyFrom((byte[])baos.toByteArray());
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            return ByteString.EMPTY;
        }
    }

    private void writeBuf(ByteBuf out, ByteBuf buf) throws IOException {
        int bodyLen = buf.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size((int)bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance((OutputStream)new ByteBufOutputStream(out), (int)headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(buf, buf.readerIndex(), bodyLen);
    }
}

