/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.protobuf;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStatistics
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger((String)"Flow");
    private static Logger metricsLogger = LoggerFactory.getLogger((String)"flow_metrics");
    private static final int DELAY = 1;
    private static final int PERIOD = 1;
    private static final TimeUnit UNIT = TimeUnit.MINUTES;
    private ChannelHandlerContext ctx = null;
    private int byteCnt = 0;
    private int pkgCnt = 0;
    private String name = "default";

    public FlowStatistics(String name) {
        this.name = name;
    }

    public void updateByteCnt(ChannelHandlerContext context, int delta) {
        if (context == null) {
            return;
        }
        this.byteCnt += delta;
        ++this.pkgCnt;
        if (this.ctx == null) {
            this.ctx = context;
            this.ctx.channel().eventLoop().scheduleAtFixedRate((Runnable)this, 1L, 1L, UNIT);
        }
    }

    @Override
    public void run() {
        if (!this.ctx.channel().isActive()) {
            throw new RuntimeException("inactive channel " + this.ctx.channel().remoteAddress());
        }
        logger.info(this.name + " >> " + this.ctx.channel().remoteAddress() + " byte count: " + this.byteCnt + "; pkg cnt: " + this.pkgCnt + " attr: " + this.ctx.channel().isOpen() + ": " + this.ctx.channel().isActive() + ": " + this.ctx.channel().isRegistered() + ": " + this.ctx.channel().isWritable());
        metricsLogger.info("transfer.byte.size {} {}", (Object)this.name, (Object)this.byteCnt);
        metricsLogger.info("transfer.record.count {} {}", (Object)this.name, (Object)this.pkgCnt);
        this.byteCnt = 0;
        this.pkgCnt = 0;
    }
}

