/*
 * Decompiled with CFR 0.152.
 */
package com.envision.energy.connective.common.protobuf;

import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NetworkTraffic {
    private AtomicLong deZipByteCnt = new AtomicLong(0L);
    private AtomicInteger dePkgCnt = new AtomicInteger(0);
    private AtomicLong enZipByteCnt = new AtomicLong(0L);
    private AtomicInteger enPkgCnt = new AtomicInteger(0);
    private AtomicLong unzipByteCnt = new AtomicLong(0L);
    private AtomicInteger recordCnt = new AtomicInteger(0);
    private AtomicInteger pointCnt = new AtomicInteger(0);
    private AtomicLong feDelay = new AtomicLong(0L);
    private AtomicLong sendDelay = new AtomicLong(0L);
    private AtomicInteger delayCnt = new AtomicInteger(0);
    private Map<String, AtomicLong> enZipByteCntMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> enPkgCntMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static final AttributeKey<NetworkTraffic> NETWORKTRAFFIC = AttributeKey.valueOf((String)"NTTFC");

    public static NetworkTraffic getByChannel(Channel channel) {
        Attribute attr = channel.attr(NETWORKTRAFFIC);
        NetworkTraffic ret = (NetworkTraffic)attr.get();
        if (ret == null) {
            ret = new NetworkTraffic();
            attr.set((Object)ret);
        }
        return ret;
    }

    public void updateDeCnt(long zipByteDelta, int pkgDelta) {
        this.deZipByteCnt.addAndGet(zipByteDelta);
        this.dePkgCnt.addAndGet(pkgDelta);
    }

    public void updateEnCnt(String msgName, long zipByteDelta, int pkgDelta) {
        if (!this.enZipByteCntMap.containsKey(msgName)) {
            this.enZipByteCntMap.put(msgName, new AtomicLong(0L));
        }
        this.enZipByteCntMap.get(msgName).addAndGet(zipByteDelta);
        this.enZipByteCnt.addAndGet(zipByteDelta);
        if (!this.enPkgCntMap.containsKey(msgName)) {
            this.enPkgCntMap.put(msgName, new AtomicInteger(0));
        }
        this.enPkgCntMap.get(msgName).addAndGet(pkgDelta);
        this.enPkgCnt.addAndGet(pkgDelta);
    }

    public void updateUnzip(long byteDelta, int recordDelta, int pointDelta) {
        this.unzipByteCnt.addAndGet(byteDelta);
        this.recordCnt.addAndGet(recordDelta);
        this.pointCnt.addAndGet(pointDelta);
    }

    public void updateDelay(long feDelta, long sendDelta) {
        this.feDelay.addAndGet(feDelta);
        this.sendDelay.addAndGet(sendDelta);
        this.delayCnt.addAndGet(1);
    }

    public void resetAll() {
        this.deZipByteCnt.set(0L);
        this.dePkgCnt.set(0);
        for (AtomicLong atomicLong : this.enZipByteCntMap.values()) {
            atomicLong.set(0L);
        }
        this.enZipByteCnt.set(0L);
        for (AtomicInteger atomicInteger : this.enPkgCntMap.values()) {
            atomicInteger.set(0);
        }
        this.enPkgCnt.set(0);
        this.unzipByteCnt.set(0L);
        this.recordCnt.set(0);
        this.pointCnt.set(0);
        this.feDelay.set(0L);
        this.sendDelay.set(0L);
        this.delayCnt.set(0);
    }

    public long getDeZipByteCnt() {
        return this.deZipByteCnt.get();
    }

    public void setDeZipByteCnt(long deZipByteCnt) {
        this.deZipByteCnt.set(deZipByteCnt);
    }

    public int getDePkgCnt() {
        return this.dePkgCnt.get();
    }

    public void setDePkgCnt(int dePkgCnt) {
        this.dePkgCnt.set(dePkgCnt);
    }

    public Map<String, Long> getEnZipByteCntMap() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> cnt : this.enZipByteCntMap.entrySet()) {
            result.put(cnt.getKey(), cnt.getValue().get());
        }
        return result;
    }

    public long getEnZipByteCnt() {
        return this.enZipByteCnt.get();
    }

    public void setEnZipByteCnt(long enZipByteCnt) {
        this.enZipByteCnt.set(enZipByteCnt);
    }

    public Map<String, Integer> getEnPkgCntMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> cnt : this.enPkgCntMap.entrySet()) {
            result.put(cnt.getKey(), cnt.getValue().get());
        }
        return result;
    }

    public int getEnPkgCnt() {
        return this.enPkgCnt.get();
    }

    public void setEnPkgCnt(int enPkgCnt) {
        this.enPkgCnt.set(enPkgCnt);
    }

    public long getUnzipByteCnt() {
        return this.unzipByteCnt.get();
    }

    public void setUnzipByteCnt(long unzipByteCnt) {
        this.unzipByteCnt.set(unzipByteCnt);
    }

    public int getRecordCnt() {
        return this.recordCnt.get();
    }

    public void setRecordCnt(int recordCnt) {
        this.recordCnt.set(recordCnt);
    }

    public int getPointCnt() {
        return this.pointCnt.get();
    }

    public void setPointCnt(int pointCnt) {
        this.pointCnt.set(pointCnt);
    }

    public float getFeDelayAvg() {
        int cnt = this.delayCnt.get();
        if (cnt > 0) {
            return (float)this.feDelay.get() / ((float)cnt * 1.0f);
        }
        return 0.0f;
    }

    public void setFeDelay(long feDelay) {
        this.feDelay.set(feDelay);
    }

    public float getSendDelayAvg() {
        int cnt = this.delayCnt.get();
        if (cnt > 0) {
            return (float)this.sendDelay.get() / ((float)cnt * 1.0f);
        }
        return 0.0f;
    }

    public void setSendDelay(long sendDelay) {
        this.sendDelay.set(sendDelay);
    }

    public int getDelayCnt() {
        return this.delayCnt.get();
    }

    public void setDelayCnt(int delayCnt) {
        this.delayCnt.set(delayCnt);
    }

    public String toString() {
        return "NetworkTraffic [deZipByteCnt=" + this.deZipByteCnt + ", dePkgCnt=" + this.dePkgCnt + ", enZipByteCnt=" + this.enZipByteCnt + ", enPkgCnt=" + this.enPkgCnt + ", unzipByteCnt=" + this.unzipByteCnt + ", recordCnt=" + this.recordCnt + ", pointCnt=" + this.pointCnt + ", feDelay=" + this.feDelay + ", sendDelay=" + this.sendDelay + ", delayCnt=" + this.delayCnt + ", enZipByteCntMap=" + this.enZipByteCntMap + ", enPkgCntMap=" + this.enPkgCntMap + "]";
    }

    public static void main(String[] args) {
        System.out.println(new NetworkTraffic());
    }
}

