package com.envisioniot.sub.client;

import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.client.internal.netty.SubClient;
import com.envisioniot.sub.client.internal.netty.SubClientCache;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * created by jie.jin on 2018/9/14.
 */
public abstract class EnosBaseService extends BaseService {

    protected MessageListener messageListener;
    protected boolean enablePreFetch = false;

    protected SubClient client;
    protected AtomicBoolean subscribed = new AtomicBoolean(false);

    private volatile boolean autoCommit = true;

    protected void connect() {
        this.client = new SubClient(this.category).setSubCategory(this.category).setHost(host).setPort(port).setAccessKey(accessKey).setSecret(accessSecret).setSubId(subId).setConsumerGroup(this.consumerGroup).setMessageListener(this.messageListener).setConnectionStateListener(this.connectionStateListener).setBatch(isBatch).setAutoCommit(autoCommit);

        this.client = this.enablePreFetch ? this.client.enablePreFetch() : this.client.disablePreFetch();
        if (requestTimeout > 0) {
            this.client.setRequestTimeout(requestTimeout);
        }

        SubClientCache.put(category, client);
        this.client.connect();
    }

    public MessageListener getMessageListener() {
        return messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void stopSub() {
        throw new RuntimeException("No implement The Method, Will be Soon...");
    }

    public void selfDoCommit() {
        if (this.client != null) {
            this.client.selfDoCommit();
        }
    }

    public void disableAutoCommit() {
        this.autoCommit = false;
        if (this.client != null) {
            this.client.disableAutoCommit();
        }
    }

    public void enableAutoCommit() {
        this.autoCommit = true;
        if (this.client != null) {
            this.client.enableAutoCommit();
        }
    }

    public boolean isAutoCommit() {
        if (this.client != null) {
            return this.client.isAutoCommit();
        }
        return this.autoCommit;
    }

    public void setAutoCommitIntervalSecond(int interval) {
        if (this.client != null) {
            this.client.setAutoCommitInterval(interval * 1000);
        }
    }

}
