package com.envisioniot.sub.client.advancedalert;

import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.google.common.base.Strings;

import java.util.List;

/**
 * @author yuanyuan.xia
 */
public class AdvancedAlertMessageListener implements MessageListener {
    private IAdvancedAlertHandler handler;

    public AdvancedAlertMessageListener(IAdvancedAlertHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        this.handler.advancedAlertRead(msg.getValue());
    }

    @Override
    public void onMessages(List<String> patchList) {
        this.handler.advancedAlertReads(patchList);
    }
}
